---
name: contract-review-checklist
description: Systematic contract review process for identifying risks and obligations
---

# Contract Review Checklist Skill

Use this skill when reviewing contracts to ensure you don't miss critical terms, obligations, or risks.

## When to Use This Skill

- Reviewing vendor agreements
- Analyzing service contracts
- Checking employment agreements
- Due diligence reviews
- Client contract negotiations

## How It Works

When you activate this skill, Claude will systematically analyze the contract through these lenses:

### 1. Party Identification
- Who are the parties?
- Are they properly identified with legal names?
- Is there clarity on who is contracting with whom?

### 2. Core Terms
- What is being exchanged? (services, goods, rights)
- What is the consideration?
- What are the payment terms and schedule?
- What is the duration/term?

### 3. Critical Dates
- When does the agreement start?
- When does it end?
- What are renewal/termination notice periods?
- Are there milestone dates?

### 4. Obligations
**Your Client's Obligations:**
- What must your client do?
- By when?
- What resources are required?
- What are the performance standards?

**Counterparty Obligations:**
- What must the other party deliver?
- What are their deadlines?
- What are their performance standards?

### 5. Risk Factors
- Liability caps (or lack thereof)
- Indemnification provisions
- Insurance requirements
- Warranties and representations
- Limitation of liability clauses

### 6. Exit Strategy
- How can the agreement be terminated?
- What are the costs of early termination?
- What happens to data/work product upon termination?
- Are there post-termination obligations?

### 7. Dispute Resolution
- Governing law
- Venue for disputes
- Arbitration vs litigation
- Attorney's fees provisions

### 8. Red Flags
- Automatic renewals
- Unilateral amendment rights
- Broad indemnification
- Excessive liability exposure
- Missing standard protections

## How to Use

Once installed, just ask Claude naturally. You don't need to mention the skill - Claude detects when to use it automatically.

**Examples:**
```
Review this vendor agreement for me.
```

```
What are the risks in this contract?
```

```
Help me analyze this service agreement.
```

Then paste the contract text or provide the file path. Claude automatically applies this systematic review framework.

## Output Format

Claude will provide:
1. **Summary** - One paragraph overview
2. **Key Terms Table** - Parties, consideration, term, termination
3. **Obligation Matrix** - Who must do what by when
4. **Risk Assessment** - High/medium/low priority issues
5. **Action Items** - What needs negotiation or clarification

## Tips

- Use this for initial review to spot issues quickly
- Run it before client meetings to prepare talking points
- Use the output to create deal summary memos
- Reference specific sections when negotiating changes

---

**Created by:** LexpertAI
**Last Updated:** January 2025
**Skill Type:** Legal Analysis
