---
name: legal-memo-drafting
description: Structure and draft legal memoranda with consistent formatting and analysis
---

# Legal Memo Drafting Skill

Use this skill to draft well-structured legal memoranda following standard format and analytical frameworks.

## When to Use This Skill

- Research memos for partners
- Client advisory letters
- Internal analysis documents
- Issue spotting memos
- Case law summaries

## How It Works

When you activate this skill, Claude will help you draft a memo following this structure:

### Standard Memo Format

**HEADER**
```
TO: [Recipient]
FROM: [Your Name]
DATE: [Current Date]
RE: [Brief Subject Line]
```

**QUESTION PRESENTED**
- One sentence framing the legal issue
- Includes key facts necessary to understand the question
- Written as a question

**BRIEF ANSWER**
- Direct answer to the question presented (usually "Yes" or "No")
- 2-3 sentences explaining the conclusion
- Cites primary authority supporting the conclusion

**FACTS**
- Only facts relevant to the legal analysis
- Chronological order when possible
- Objective tone (no argumentative characterizations)
- Includes both favorable and unfavorable facts

**DISCUSSION**

The skill will organize analysis using IRAC framework:

**Issue:** State the legal question
**Rule:** Articulate the applicable legal rule/standard
**Application:** Apply the rule to your facts
**Conclusion:** State the outcome of that application

For complex issues, the skill will:
- Break analysis into sub-issues
- Use clear headings and subheadings
- Distinguish favorable and unfavorable cases
- Address counterarguments
- Note ambiguities or unsettled law

**CONCLUSION**
- Restate the answer
- Summarize key reasoning
- Note practical implications or next steps

## How to Use

Once installed, just ask Claude naturally. You don't need to mention the skill - Claude detects when to use it automatically.

**Examples:**
```
Draft a research memo about whether we can enforce this non-compete in Texas.
```

```
Help me write a client advisory letter about the copyright fair use issue.
```

```
Turn these case notes into a memo for the partner.
```

Then provide the facts, research, or case notes. Claude automatically structures it using proper memo format and IRAC analysis.

## Output Quality Standards

Claude will ensure the memo:
- Uses clear, precise language
- Avoids conclusory statements without support
- Cites authority for each legal proposition
- Acknowledges weaknesses in the analysis
- Remains objective (not argumentative)
- Uses consistent citation format

## Customization Options

You can modify the output by specifying:
- **Audience:** Partner review vs client advisory (affects tone)
- **Depth:** Quick analysis vs comprehensive research memo
- **Format:** Traditional IRAC vs issue-by-issue
- **Citation Style:** Bluebook, ALWD, or simplified

## Tips

- Provide all relevant facts upfront (the skill will filter what's needed)
- Specify jurisdiction to ensure correct law is applied
- Mention if certain arguments should be prioritized
- Ask for "counter-analysis" section if anticipating opposition

## Example Output Preview

```
TO: Sarah Johnson, Partner
FROM: [Associate Name]
DATE: January 6, 2025
RE: Enforceability of Non-Compete Agreement Against Former Employee

QUESTION PRESENTED

Is a two-year non-compete agreement enforceable against a former
sales employee in Texas when the agreement restricts all work in
the software industry within a 50-mile radius?

BRIEF ANSWER

Likely no. Texas courts disfavor non-compete agreements and will
only enforce them if they are reasonable in scope, duration, and
geographic area. A 50-mile radius covering an entire industry for
two years will likely be found overbroad...

[continues with full analysis]
```

---

**Created by:** LexpertAI
**Last Updated:** January 2025
**Skill Type:** Legal Writing
